#region "Legal Notice"
/*******************************************************************************
 *
 * Copyright (c) 2006 Alien Technology Corporation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1)	Redistributions of source code must retain the above copyright 
 *		notice, this list of conditions and the following disclaimer. 
 *
 * 2)	Redistributions in binary form must reproduce the above copyright 
 *		notice, this list of conditions and the following disclaimer 
 *		in the documentation and/or other materials provided with the distribution. 
 *
 * 3)	Neither the name of Alien Technology Corporation nor the names of any 
 *		contributors may be used to endorse or promote products derived from this 
 *		software without specific prior written permission. 
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 *	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED. IN NO EVENT SHALL ALIEN TECHNOLOGY CORPORATION OR ITS 
 *	CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 *	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 *	OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 *	WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 *	OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 *	OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************************/

#endregion

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Diagnostics;
using System.Threading;
using System.Collections.Generic;

using nsAlienRFID2;

namespace Ex6
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private clsReader mReader;
		private ReaderInfo mReaderInfo;
		private ComInterface meReaderInterface = ComInterface.enumTCPIP;
		private ArrayList malTags;
		private String msTags;

        private List<AlienStatistics> mlMyStatistics = null;
        

		#region Auto generated code

		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.NumericUpDown PortUD;
		private System.Windows.Forms.Button btnDisconnect;
		private System.Windows.Forms.Button btnConnect;
		private System.Windows.Forms.GroupBox grpNetwork;
		private System.Windows.Forms.GroupBox grpSerial;
		private System.Windows.Forms.GroupBox grpConnection;
		private System.Windows.Forms.RadioButton rdoSerial;
		private System.Windows.Forms.RadioButton rdoTCP;
		private System.Windows.Forms.DataGrid dataGrid1;
		private System.Windows.Forms.Button btnParse;
		private System.Windows.Forms.Button btnTagList;
		private System.Windows.Forms.GroupBox groupFormat;
		private System.Windows.Forms.RadioButton rdoXML;
		private System.Windows.Forms.RadioButton rdoText;
		private System.Windows.Forms.TextBox textReaderTalk;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ComboBox cboPorts;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.NumericUpDown ReceiveUP;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.ComboBox cboHostBaudRate;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.GroupBox groupBox1;
        private System.Windows.Forms.Label lblStatus;
        private GroupBox grpStatistics;
        private GroupBox grpTags;
        private BindingSource StatisticsBindingSrc;
        private DataGridView grvStats;
        private Button btnStats;
        private DataGridViewTextBoxColumn statisticsSourceName;
        private DataGridViewTextBoxColumn readCountDataGridViewTextBoxColumn;
        private DataGridViewTextBoxColumn uniqueReadCountDataGridViewTextBoxColumn;
        private DataGridViewTextBoxColumn failedReadCountDataGridViewTextBoxColumn;
        private DataGridViewTextBoxColumn writeCountDataGridViewTextBoxColumn;
        private DataGridViewTextBoxColumn failedWriteCountDataGridViewTextBoxColumn;
        private DataGridViewTextBoxColumn lockCountDataGridViewTextBoxColumn;
        private DataGridViewTextBoxColumn failedLockCountDataGridViewTextBoxColumn;
        private DataGridViewTextBoxColumn killCountDataGridViewTextBoxColumn;
        private DataGridViewTextBoxColumn failedKillCountDataGridViewTextBoxColumn;
		private System.ComponentModel.IContainer components;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            this.grpNetwork = new System.Windows.Forms.GroupBox();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.label2 = new System.Windows.Forms.Label();
            this.PortUD = new System.Windows.Forms.NumericUpDown();
            this.label1 = new System.Windows.Forms.Label();
            this.btnDisconnect = new System.Windows.Forms.Button();
            this.btnConnect = new System.Windows.Forms.Button();
            this.grpSerial = new System.Windows.Forms.GroupBox();
            this.cboHostBaudRate = new System.Windows.Forms.ComboBox();
            this.label4 = new System.Windows.Forms.Label();
            this.cboPorts = new System.Windows.Forms.ComboBox();
            this.label5 = new System.Windows.Forms.Label();
            this.rdoSerial = new System.Windows.Forms.RadioButton();
            this.rdoTCP = new System.Windows.Forms.RadioButton();
            this.grpConnection = new System.Windows.Forms.GroupBox();
            this.ReceiveUP = new System.Windows.Forms.NumericUpDown();
            this.label3 = new System.Windows.Forms.Label();
            this.dataGrid1 = new System.Windows.Forms.DataGrid();
            this.btnParse = new System.Windows.Forms.Button();
            this.btnTagList = new System.Windows.Forms.Button();
            this.groupFormat = new System.Windows.Forms.GroupBox();
            this.rdoXML = new System.Windows.Forms.RadioButton();
            this.rdoText = new System.Windows.Forms.RadioButton();
            this.textReaderTalk = new System.Windows.Forms.TextBox();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.lblStatus = new System.Windows.Forms.Label();
            this.grpStatistics = new System.Windows.Forms.GroupBox();
            this.grvStats = new System.Windows.Forms.DataGridView();
            this.statisticsSourceName = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.readCountDataGridViewTextBoxColumn = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.uniqueReadCountDataGridViewTextBoxColumn = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.failedReadCountDataGridViewTextBoxColumn = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.writeCountDataGridViewTextBoxColumn = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.failedWriteCountDataGridViewTextBoxColumn = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.lockCountDataGridViewTextBoxColumn = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.failedLockCountDataGridViewTextBoxColumn = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.killCountDataGridViewTextBoxColumn = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.failedKillCountDataGridViewTextBoxColumn = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.StatisticsBindingSrc = new System.Windows.Forms.BindingSource(this.components);
            this.btnStats = new System.Windows.Forms.Button();
            this.grpTags = new System.Windows.Forms.GroupBox();
            this.grpNetwork.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).BeginInit();
            this.grpSerial.SuspendLayout();
            this.grpConnection.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.ReceiveUP)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).BeginInit();
            this.groupFormat.SuspendLayout();
            this.groupBox1.SuspendLayout();
            this.grpStatistics.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.grvStats)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.StatisticsBindingSrc)).BeginInit();
            this.grpTags.SuspendLayout();
            this.SuspendLayout();
            // 
            // grpNetwork
            // 
            this.grpNetwork.Controls.Add(this.textBox1);
            this.grpNetwork.Controls.Add(this.label2);
            this.grpNetwork.Controls.Add(this.PortUD);
            this.grpNetwork.Controls.Add(this.label1);
            this.grpNetwork.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpNetwork.Location = new System.Drawing.Point(17, 16);
            this.grpNetwork.Name = "grpNetwork";
            this.grpNetwork.Size = new System.Drawing.Size(232, 104);
            this.grpNetwork.TabIndex = 5;
            this.grpNetwork.TabStop = false;
            this.grpNetwork.Text = "Network Settings";
            // 
            // textBox1
            // 
            this.textBox1.Location = new System.Drawing.Point(116, 24);
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(100, 20);
            this.textBox1.TabIndex = 1;
            this.toolTip1.SetToolTip(this.textBox1, "Enter reader\'s IP Address here (use \'Get IPAddress\' command to obtain it during a" +
                    " Serial Connection session)");
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(32, 32);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(80, 20);
            this.label2.TabIndex = 9;
            this.label2.Text = "Remote Host:";
            // 
            // PortUD
            // 
            this.PortUD.Location = new System.Drawing.Point(131, 61);
            this.PortUD.Name = "PortUD";
            this.PortUD.Size = new System.Drawing.Size(72, 20);
            this.PortUD.TabIndex = 8;
            this.PortUD.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.PortUD.Value = new decimal(new int[] {
            23,
            0,
            0,
            0});
            this.PortUD.ValueChanged += new System.EventHandler(this.MyUpDowns_ValueChanged);
            // 
            // label1
            // 
            this.label1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label1.Location = new System.Drawing.Point(31, 66);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(67, 20);
            this.label1.TabIndex = 6;
            this.label1.Text = "Telnet Port:";
            // 
            // btnDisconnect
            // 
            this.btnDisconnect.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDisconnect.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnDisconnect.Enabled = false;
            this.btnDisconnect.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnDisconnect.Location = new System.Drawing.Point(600, 33);
            this.btnDisconnect.Name = "btnDisconnect";
            this.btnDisconnect.Size = new System.Drawing.Size(99, 35);
            this.btnDisconnect.TabIndex = 21;
            this.btnDisconnect.Text = "&Disconnect";
            this.toolTip1.SetToolTip(this.btnDisconnect, "Close connection with reader");
            this.btnDisconnect.UseVisualStyleBackColor = false;
            this.btnDisconnect.Click += new System.EventHandler(this.btnDisconnect_Click);
            // 
            // btnConnect
            // 
            this.btnConnect.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnConnect.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnConnect.Location = new System.Drawing.Point(265, 33);
            this.btnConnect.Name = "btnConnect";
            this.btnConnect.Size = new System.Drawing.Size(99, 35);
            this.btnConnect.TabIndex = 18;
            this.btnConnect.Text = "Co&nnect + Login";
            this.toolTip1.SetToolTip(this.btnConnect, "Connect to reader");
            this.btnConnect.UseVisualStyleBackColor = false;
            this.btnConnect.Click += new System.EventHandler(this.btnConnect_Click);
            // 
            // grpSerial
            // 
            this.grpSerial.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSerial.Controls.Add(this.cboHostBaudRate);
            this.grpSerial.Controls.Add(this.label4);
            this.grpSerial.Controls.Add(this.cboPorts);
            this.grpSerial.Controls.Add(this.label5);
            this.grpSerial.Enabled = false;
            this.grpSerial.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpSerial.Location = new System.Drawing.Point(711, 20);
            this.grpSerial.Name = "grpSerial";
            this.grpSerial.Size = new System.Drawing.Size(229, 104);
            this.grpSerial.TabIndex = 22;
            this.grpSerial.TabStop = false;
            this.grpSerial.Text = "Com Port";
            // 
            // cboHostBaudRate
            // 
            this.cboHostBaudRate.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboHostBaudRate.Items.AddRange(new object[] {
            "115200",
            "57600",
            "38400",
            "19200",
            "9600"});
            this.cboHostBaudRate.Location = new System.Drawing.Point(113, 56);
            this.cboHostBaudRate.Name = "cboHostBaudRate";
            this.cboHostBaudRate.Size = new System.Drawing.Size(96, 21);
            this.cboHostBaudRate.TabIndex = 17;
            this.cboHostBaudRate.SelectedIndexChanged += new System.EventHandler(this.cboHostBaudRate_SelectedIndexChanged);
            // 
            // label4
            // 
            this.label4.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label4.Location = new System.Drawing.Point(17, 60);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(100, 16);
            this.label4.TabIndex = 18;
            this.label4.Text = "Host Baud Rate:";
            // 
            // cboPorts
            // 
            this.cboPorts.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboPorts.Items.AddRange(new object[] {
            "COM1:",
            "COM2:",
            "COM3:",
            "COM4:",
            "COM5:",
            "COM6:",
            "COM7:",
            "COM8:",
            "COM9:"});
            this.cboPorts.Location = new System.Drawing.Point(113, 24);
            this.cboPorts.Name = "cboPorts";
            this.cboPorts.Size = new System.Drawing.Size(96, 21);
            this.cboPorts.TabIndex = 13;
            this.cboPorts.SelectedIndexChanged += new System.EventHandler(this.cboPorts_SelectedIndexChanged);
            // 
            // label5
            // 
            this.label5.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label5.Location = new System.Drawing.Point(17, 32);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(72, 20);
            this.label5.TabIndex = 14;
            this.label5.Text = "Port Name:";
            // 
            // rdoSerial
            // 
            this.rdoSerial.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.rdoSerial.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoSerial.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoSerial.Location = new System.Drawing.Point(162, 23);
            this.rdoSerial.Name = "rdoSerial";
            this.rdoSerial.Size = new System.Drawing.Size(56, 21);
            this.rdoSerial.TabIndex = 1;
            this.rdoSerial.Text = "Seria&l";
            this.toolTip1.SetToolTip(this.rdoSerial, "Select Serial connection");
            this.rdoSerial.UseVisualStyleBackColor = false;
            this.rdoSerial.CheckedChanged += new System.EventHandler(this.rdoSerial_CheckedChanged);
            // 
            // rdoTCP
            // 
            this.rdoTCP.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoTCP.Checked = true;
            this.rdoTCP.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoTCP.Location = new System.Drawing.Point(24, 24);
            this.rdoTCP.Name = "rdoTCP";
            this.rdoTCP.Size = new System.Drawing.Size(46, 21);
            this.rdoTCP.TabIndex = 0;
            this.rdoTCP.TabStop = true;
            this.rdoTCP.Text = "TC&P";
            this.toolTip1.SetToolTip(this.rdoTCP, "Select TCP connection");
            this.rdoTCP.UseVisualStyleBackColor = false;
            this.rdoTCP.CheckedChanged += new System.EventHandler(this.rdoTCP_CheckedChanged);
            // 
            // grpConnection
            // 
            this.grpConnection.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.grpConnection.BackColor = System.Drawing.SystemColors.ControlText;
            this.grpConnection.Controls.Add(this.rdoSerial);
            this.grpConnection.Controls.Add(this.rdoTCP);
            this.grpConnection.Controls.Add(this.ReceiveUP);
            this.grpConnection.Controls.Add(this.label3);
            this.grpConnection.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpConnection.Location = new System.Drawing.Point(370, 20);
            this.grpConnection.Name = "grpConnection";
            this.grpConnection.Size = new System.Drawing.Size(224, 56);
            this.grpConnection.TabIndex = 24;
            this.grpConnection.TabStop = false;
            this.grpConnection.Text = "Connection";
            // 
            // ReceiveUP
            // 
            this.ReceiveUP.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.ReceiveUP.Increment = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.ReceiveUP.Location = new System.Drawing.Point(76, 26);
            this.ReceiveUP.Maximum = new decimal(new int[] {
            2147483647,
            0,
            0,
            0});
            this.ReceiveUP.Minimum = new decimal(new int[] {
            60000,
            0,
            0,
            0});
            this.ReceiveUP.Name = "ReceiveUP";
            this.ReceiveUP.Size = new System.Drawing.Size(73, 20);
            this.ReceiveUP.TabIndex = 31;
            this.ReceiveUP.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.ReceiveUP.ThousandsSeparator = true;
            this.ReceiveUP.Value = new decimal(new int[] {
            60000,
            0,
            0,
            0});
            // 
            // label3
            // 
            this.label3.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label3.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label3.Location = new System.Drawing.Point(73, 10);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(88, 13);
            this.label3.TabIndex = 30;
            this.label3.Text = "Timeout Interval:";
            // 
            // dataGrid1
            // 
            this.dataGrid1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.dataGrid1.BackgroundColor = System.Drawing.SystemColors.WindowFrame;
            this.dataGrid1.CaptionBackColor = System.Drawing.SystemColors.Info;
            this.dataGrid1.CaptionVisible = false;
            this.dataGrid1.DataMember = "";
            this.dataGrid1.ForeColor = System.Drawing.SystemColors.MenuText;
            this.dataGrid1.HeaderBackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.dataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.dataGrid1.Location = new System.Drawing.Point(23, 122);
            this.dataGrid1.Name = "dataGrid1";
            this.dataGrid1.RowHeadersVisible = false;
            this.dataGrid1.Size = new System.Drawing.Size(884, 125);
            this.dataGrid1.TabIndex = 27;
            this.toolTip1.SetToolTip(this.dataGrid1, "Displays Parsed Tag List");
            // 
            // btnParse
            // 
            this.btnParse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnParse.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnParse.Location = new System.Drawing.Point(564, 89);
            this.btnParse.Name = "btnParse";
            this.btnParse.Size = new System.Drawing.Size(100, 34);
            this.btnParse.TabIndex = 26;
            this.btnParse.Text = "&Parse Tag List";
            this.toolTip1.SetToolTip(this.btnParse, "Parse obtained Tag List");
            this.btnParse.UseVisualStyleBackColor = false;
            this.btnParse.Click += new System.EventHandler(this.btnParse_Click);
            // 
            // btnTagList
            // 
            this.btnTagList.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnTagList.Location = new System.Drawing.Point(300, 89);
            this.btnTagList.Name = "btnTagList";
            this.btnTagList.Size = new System.Drawing.Size(100, 35);
            this.btnTagList.TabIndex = 25;
            this.btnTagList.Text = "Get &Tag List";
            this.toolTip1.SetToolTip(this.btnTagList, "Obtain current Tag List");
            this.btnTagList.UseVisualStyleBackColor = false;
            this.btnTagList.Click += new System.EventHandler(this.btnTagList_Click);
            // 
            // groupFormat
            // 
            this.groupFormat.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.groupFormat.BackColor = System.Drawing.SystemColors.ControlText;
            this.groupFormat.Controls.Add(this.rdoXML);
            this.groupFormat.Controls.Add(this.rdoText);
            this.groupFormat.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.groupFormat.Location = new System.Drawing.Point(406, 89);
            this.groupFormat.Name = "groupFormat";
            this.groupFormat.Size = new System.Drawing.Size(152, 35);
            this.groupFormat.TabIndex = 28;
            this.groupFormat.TabStop = false;
            this.groupFormat.Text = "Tag List Format";
            // 
            // rdoXML
            // 
            this.rdoXML.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoXML.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoXML.Location = new System.Drawing.Point(86, 11);
            this.rdoXML.Name = "rdoXML";
            this.rdoXML.Size = new System.Drawing.Size(48, 21);
            this.rdoXML.TabIndex = 1;
            this.rdoXML.Text = "&XML";
            this.toolTip1.SetToolTip(this.rdoXML, "Set XML format for the Tag List");
            this.rdoXML.UseVisualStyleBackColor = false;
            this.rdoXML.CheckedChanged += new System.EventHandler(this.rdoXML_CheckedChanged);
            // 
            // rdoText
            // 
            this.rdoText.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoText.Checked = true;
            this.rdoText.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoText.Location = new System.Drawing.Point(24, 11);
            this.rdoText.Name = "rdoText";
            this.rdoText.Size = new System.Drawing.Size(56, 21);
            this.rdoText.TabIndex = 0;
            this.rdoText.TabStop = true;
            this.rdoText.Text = "Tex&t";
            this.toolTip1.SetToolTip(this.rdoText, "Set Text format for the Tag List");
            this.rdoText.UseVisualStyleBackColor = false;
            this.rdoText.CheckedChanged += new System.EventHandler(this.rdoText_CheckedChanged);
            // 
            // textReaderTalk
            // 
            this.textReaderTalk.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.textReaderTalk.BackColor = System.Drawing.SystemColors.WindowFrame;
            this.textReaderTalk.ForeColor = System.Drawing.SystemColors.Info;
            this.textReaderTalk.Location = new System.Drawing.Point(23, 19);
            this.textReaderTalk.Multiline = true;
            this.textReaderTalk.Name = "textReaderTalk";
            this.textReaderTalk.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.textReaderTalk.Size = new System.Drawing.Size(889, 97);
            this.textReaderTalk.TabIndex = 29;
            this.toolTip1.SetToolTip(this.textReaderTalk, "Provides \'Telnet / HyperTerminal\' - like communication");
            this.textReaderTalk.KeyUp += new System.Windows.Forms.KeyEventHandler(this.textReaderTalk_KeyUp);
            // 
            // groupBox1
            // 
            this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox1.BackColor = System.Drawing.SystemColors.ControlText;
            this.groupBox1.Controls.Add(this.lblStatus);
            this.groupBox1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.groupBox1.Location = new System.Drawing.Point(17, 559);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(923, 44);
            this.groupBox1.TabIndex = 32;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Status";
            // 
            // lblStatus
            // 
            this.lblStatus.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.lblStatus.Location = new System.Drawing.Point(48, 13);
            this.lblStatus.Name = "lblStatus";
            this.lblStatus.Size = new System.Drawing.Size(831, 20);
            this.lblStatus.TabIndex = 7;
            // 
            // grpStatistics
            // 
            this.grpStatistics.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.grpStatistics.Controls.Add(this.grvStats);
            this.grpStatistics.Controls.Add(this.btnStats);
            this.grpStatistics.ForeColor = System.Drawing.SystemColors.WindowText;
            this.grpStatistics.Location = new System.Drawing.Point(17, 398);
            this.grpStatistics.Name = "grpStatistics";
            this.grpStatistics.Size = new System.Drawing.Size(923, 160);
            this.grpStatistics.TabIndex = 33;
            this.grpStatistics.TabStop = false;
            // 
            // grvStats
            // 
            this.grvStats.AllowUserToDeleteRows = false;
            this.grvStats.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.grvStats.AutoGenerateColumns = false;
            this.grvStats.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
            this.grvStats.Columns.AddRange(new System.Windows.Forms.DataGridViewColumn[] {
            this.statisticsSourceName,
            this.readCountDataGridViewTextBoxColumn,
            this.uniqueReadCountDataGridViewTextBoxColumn,
            this.failedReadCountDataGridViewTextBoxColumn,
            this.writeCountDataGridViewTextBoxColumn,
            this.failedWriteCountDataGridViewTextBoxColumn,
            this.lockCountDataGridViewTextBoxColumn,
            this.failedLockCountDataGridViewTextBoxColumn,
            this.killCountDataGridViewTextBoxColumn,
            this.failedKillCountDataGridViewTextBoxColumn});
            this.grvStats.DataSource = this.StatisticsBindingSrc;
            this.grvStats.Location = new System.Drawing.Point(23, 29);
            this.grvStats.Name = "grvStats";
            this.grvStats.ReadOnly = true;
            this.grvStats.RowHeadersVisible = false;
            this.grvStats.Size = new System.Drawing.Size(884, 125);
            this.grvStats.TabIndex = 0;
            // 
            // statisticsSourceName
            // 
            this.statisticsSourceName.DataPropertyName = "Name";
            this.statisticsSourceName.HeaderText = "Source Name";
            this.statisticsSourceName.Name = "statisticsSourceName";
            this.statisticsSourceName.ReadOnly = true;
            this.statisticsSourceName.Width = 70;
            // 
            // readCountDataGridViewTextBoxColumn
            // 
            this.readCountDataGridViewTextBoxColumn.AutoSizeMode = System.Windows.Forms.DataGridViewAutoSizeColumnMode.Fill;
            this.readCountDataGridViewTextBoxColumn.DataPropertyName = "ReadCount";
            this.readCountDataGridViewTextBoxColumn.HeaderText = "Reads";
            this.readCountDataGridViewTextBoxColumn.Name = "readCountDataGridViewTextBoxColumn";
            this.readCountDataGridViewTextBoxColumn.ReadOnly = true;
            // 
            // uniqueReadCountDataGridViewTextBoxColumn
            // 
            this.uniqueReadCountDataGridViewTextBoxColumn.DataPropertyName = "UniqueReadCount";
            this.uniqueReadCountDataGridViewTextBoxColumn.HeaderText = "Unique Reads";
            this.uniqueReadCountDataGridViewTextBoxColumn.Name = "uniqueReadCountDataGridViewTextBoxColumn";
            this.uniqueReadCountDataGridViewTextBoxColumn.ReadOnly = true;
            this.uniqueReadCountDataGridViewTextBoxColumn.Width = 80;
            // 
            // failedReadCountDataGridViewTextBoxColumn
            // 
            this.failedReadCountDataGridViewTextBoxColumn.DataPropertyName = "FailedReadCount";
            this.failedReadCountDataGridViewTextBoxColumn.HeaderText = "Failed Reads";
            this.failedReadCountDataGridViewTextBoxColumn.Name = "failedReadCountDataGridViewTextBoxColumn";
            this.failedReadCountDataGridViewTextBoxColumn.ReadOnly = true;
            this.failedReadCountDataGridViewTextBoxColumn.Width = 80;
            // 
            // writeCountDataGridViewTextBoxColumn
            // 
            this.writeCountDataGridViewTextBoxColumn.DataPropertyName = "WriteCount";
            this.writeCountDataGridViewTextBoxColumn.HeaderText = "Writes";
            this.writeCountDataGridViewTextBoxColumn.Name = "writeCountDataGridViewTextBoxColumn";
            this.writeCountDataGridViewTextBoxColumn.ReadOnly = true;
            this.writeCountDataGridViewTextBoxColumn.Width = 70;
            // 
            // failedWriteCountDataGridViewTextBoxColumn
            // 
            this.failedWriteCountDataGridViewTextBoxColumn.DataPropertyName = "FailedWriteCount";
            this.failedWriteCountDataGridViewTextBoxColumn.HeaderText = "Failed Writes";
            this.failedWriteCountDataGridViewTextBoxColumn.Name = "failedWriteCountDataGridViewTextBoxColumn";
            this.failedWriteCountDataGridViewTextBoxColumn.ReadOnly = true;
            this.failedWriteCountDataGridViewTextBoxColumn.Width = 80;
            // 
            // lockCountDataGridViewTextBoxColumn
            // 
            this.lockCountDataGridViewTextBoxColumn.DataPropertyName = "LockCount";
            this.lockCountDataGridViewTextBoxColumn.HeaderText = "Locks";
            this.lockCountDataGridViewTextBoxColumn.Name = "lockCountDataGridViewTextBoxColumn";
            this.lockCountDataGridViewTextBoxColumn.ReadOnly = true;
            this.lockCountDataGridViewTextBoxColumn.Width = 70;
            // 
            // failedLockCountDataGridViewTextBoxColumn
            // 
            this.failedLockCountDataGridViewTextBoxColumn.DataPropertyName = "FailedLockCount";
            this.failedLockCountDataGridViewTextBoxColumn.HeaderText = "Failed Locks";
            this.failedLockCountDataGridViewTextBoxColumn.Name = "failedLockCountDataGridViewTextBoxColumn";
            this.failedLockCountDataGridViewTextBoxColumn.ReadOnly = true;
            this.failedLockCountDataGridViewTextBoxColumn.Width = 80;
            // 
            // killCountDataGridViewTextBoxColumn
            // 
            this.killCountDataGridViewTextBoxColumn.DataPropertyName = "KillCount";
            this.killCountDataGridViewTextBoxColumn.HeaderText = "Kills";
            this.killCountDataGridViewTextBoxColumn.Name = "killCountDataGridViewTextBoxColumn";
            this.killCountDataGridViewTextBoxColumn.ReadOnly = true;
            this.killCountDataGridViewTextBoxColumn.Width = 70;
            // 
            // failedKillCountDataGridViewTextBoxColumn
            // 
            this.failedKillCountDataGridViewTextBoxColumn.DataPropertyName = "FailedKillCount";
            this.failedKillCountDataGridViewTextBoxColumn.HeaderText = "Failed Kills";
            this.failedKillCountDataGridViewTextBoxColumn.Name = "failedKillCountDataGridViewTextBoxColumn";
            this.failedKillCountDataGridViewTextBoxColumn.ReadOnly = true;
            this.failedKillCountDataGridViewTextBoxColumn.Width = 80;
            // 
            // StatisticsBindingSrc
            // 
            this.StatisticsBindingSrc.DataSource = typeof(nsAlienRFID2.AlienStatistics);
            // 
            // btnStats
            // 
            this.btnStats.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnStats.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnStats.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnStats.Location = new System.Drawing.Point(23, -2);
            this.btnStats.Name = "btnStats";
            this.btnStats.Size = new System.Drawing.Size(100, 25);
            this.btnStats.TabIndex = 27;
            this.btnStats.Text = "Get &Statistics";
            this.btnStats.UseVisualStyleBackColor = false;
            this.btnStats.Click += new System.EventHandler(this.btnStats_Click);
            // 
            // grpTags
            // 
            this.grpTags.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.grpTags.Controls.Add(this.textReaderTalk);
            this.grpTags.Controls.Add(this.dataGrid1);
            this.grpTags.ForeColor = System.Drawing.SystemColors.Info;
            this.grpTags.Location = new System.Drawing.Point(17, 140);
            this.grpTags.Name = "grpTags";
            this.grpTags.Size = new System.Drawing.Size(923, 253);
            this.grpTags.TabIndex = 34;
            this.grpTags.TabStop = false;
            this.grpTags.Text = "Current Tags";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.BackColor = System.Drawing.SystemColors.ControlText;
            this.ClientSize = new System.Drawing.Size(964, 613);
            this.Controls.Add(this.grpTags);
            this.Controls.Add(this.grpStatistics);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this.groupFormat);
            this.Controls.Add(this.btnParse);
            this.Controls.Add(this.btnTagList);
            this.Controls.Add(this.grpConnection);
            this.Controls.Add(this.grpSerial);
            this.Controls.Add(this.btnDisconnect);
            this.Controls.Add(this.btnConnect);
            this.Controls.Add(this.grpNetwork);
            this.MinimumSize = new System.Drawing.Size(760, 528);
            this.Name = "Form1";
            this.Text = "Alien Example 6 (TagList)";
            this.Load += new System.EventHandler(this.Form1_Load);
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.Form1_FormClosing);
            this.grpNetwork.ResumeLayout(false);
            this.grpNetwork.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).EndInit();
            this.grpSerial.ResumeLayout(false);
            this.grpConnection.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.ReceiveUP)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).EndInit();
            this.groupFormat.ResumeLayout(false);
            this.groupBox1.ResumeLayout(false);
            this.grpStatistics.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.grvStats)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.StatisticsBindingSrc)).EndInit();
            this.grpTags.ResumeLayout(false);
            this.grpTags.PerformLayout();
            this.ResumeLayout(false);

		}

		[STAThread]
		static void Main() 
		{
				Application.Run(new Form1());
		}

		#endregion

		private void DisplayText(String data)
		{
            if (data == null) return;

			if (!data.StartsWith("\r\n"))
			{
				data = "\r\n" + data;
			}
			if (!data.EndsWith("\r\n"))
			{
				data += "\r\n";
			}
			if (textReaderTalk.TextLength > 32767)
				textReaderTalk.Text = "... Text removed\r\n";
			textReaderTalk.Text += data;
			this.Cursor = Cursors.Default;
			textReaderTalk.Focus();
			textReaderTalk.SelectAll();
			textReaderTalk.ScrollToCaret();
		}

		private void ManageGUI (bool flag)
		{
			btnDisconnect.Enabled = flag;
			btnConnect.Enabled = !flag;
			grpConnection.Enabled = !flag;
			btnTagList.Enabled = flag;
			btnParse.Enabled = flag;
			groupFormat.Enabled = flag;
		}


		private void Form1_Load(object sender, System.EventArgs e)
		{
            string exePath = Application.ExecutablePath;
            int idx = exePath.LastIndexOf("\\");
            if (idx != -1)
                AlienLog.Path = exePath.Substring(0, idx + 1);
            AlienLog.WriteLine(true, "Starting the 'Ex6-Tag List' applications.");

            mReader = new clsReader(true);

            mReaderInfo = mReader.ReaderSettings;

			this.Text = "Alien Library .NET - Testing Tag List";
			Thread.CurrentThread.Name = "Alien-Ex.6: Test Tag List";
			btnTagList.Enabled = false;
			btnParse.Enabled = false;
		}

		private void MyUpDowns_ValueChanged(object sender, System.EventArgs e)
		{
			NumericUpDown who = (NumericUpDown)sender;
			if (who.Name == "PortUD")
			{
				mReaderInfo.TelnetPort = Convert.ToInt32(who.Value);
				mReader.ReaderSettings = mReaderInfo;
			}
			else
				mReader.ComTimeOutInterval = Convert.ToInt32(who.Value);
		}

		private void btnConnect_Click(object sender, System.EventArgs e)
		{
			String result;
			this.Cursor = Cursors.WaitCursor;
			try		// extra precausion though it shouldn't throw exceptions
			{
				if (meReaderInterface == ComInterface.enumTCPIP)
					mReader.InitOnNetwork(textBox1.Text, Convert.ToInt32(PortUD.Value));
				else
					mReader.InitOnCom();

				lblStatus.Text = "Connecting to the reader...";
				this.Cursor = Cursors.WaitCursor;

				result = mReader.Connect();
				if (mReader.IsConnected)
				{
					if (meReaderInterface == ComInterface.enumTCPIP)
					{
						lblStatus.Text = "Logging in...";
						this.Cursor = Cursors.WaitCursor;
						if (!mReader.Login("alien", "password"))		//returns result synchronously
						{
							lblStatus.Text = "Login failed! Calling Disconnect()...";
							mReader.Disconnect();
							return;				//------------>
						}
					}
					ManageGUI(true);
					textReaderTalk.Visible = true;

					// to make it faster and not to lose any tag
					mReader.AutoMode = "On";
				}
				lblStatus.Text = result;
			}
			catch(Exception ex)
			{
				lblStatus.Text = "Exception in btnConnect_Click(): " + ex.Message;
			}
			this.Cursor = Cursors.Default;
		}


		private void btnDisconnect_Click(object sender, System.EventArgs e)
		{
			this.Cursor = Cursors.WaitCursor;	
			mReader.AutoMode = "Off";
			mReader.Disconnect();
			ManageGUI(false);
			this.Cursor = Cursors.Default;	
			if (meReaderInterface == ComInterface.enumTCPIP)
				grpNetwork.Enabled = true;
			else
				grpSerial.Enabled = true;
		}

		private void rdoSerial_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = rdoSerial.Checked;
			grpSerial.Enabled = state;
			grpNetwork.Enabled = !state;
			btnConnect.Text = (state ? "Co&nnect" : "Co&nnect + Login");
			meReaderInterface = (state ? ComInterface.enumSerial : ComInterface.enumTCPIP);
			mReaderInfo.InterfaceType = meReaderInterface;
			mReader.ReaderSettings = mReaderInfo;
		}

		private void rdoTCP_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = rdoTCP.Checked;
			grpSerial.Enabled = !state;
			grpNetwork.Enabled = state;
			btnConnect.Text = (state ? "Co&nnect + Login" : "Co&nnect" );
			meReaderInterface = (state ? ComInterface.enumTCPIP : ComInterface.enumSerial);
			mReaderInfo.InterfaceType = meReaderInterface;
			mReader.ReaderSettings = mReaderInfo;
			textBox1.Select();
		}

		private void btnTagList_Click(object sender, System.EventArgs e)
		{
			this.Cursor = Cursors.WaitCursor;
            mReader.TagListFormat = rdoText.Checked ? "Text" : "XML";
            //mReader.TagListCustomFormat = "%i, %a, %D %T, %p, %l";
			string result = null;
			try 
			{
				result = mReader.TagList;
			}
			catch(Exception ex)
			{
				lblStatus.Text = ex.Message;
			}
			if ((result != null) && 
                (result.Length > 0) && 
                (result.IndexOf("No Tags") == -1))
				msTags = result;
			DisplayText(result);
			this.Cursor = Cursors.Default;
			btnParse.Enabled = true;
		}

		private void btnParse_Click(object sender, System.EventArgs e)
		{

			if ((msTags != null) && (msTags.Length > 0))
			{
				this.Cursor = Cursors.WaitCursor;
				TagInfo[] aTags;
				try
				{
					int cnt = AlienUtils.ParseTagList(msTags, out aTags);
					if (cnt == 0)
					{
						lblStatus.Text = "No tags to parse.";
					}
					else
					{
						malTags = new ArrayList(aTags);
						dataGrid1.DataSource = malTags;
						if (cnt == 1)
							lblStatus.Text = "1 tag found.";
						else
							lblStatus.Text = cnt.ToString() + " tags found.";
					}
				}
				catch (Exception ex)
				{
					// e.g.: in case of malformed XML
					lblStatus.Text = "Exception parsing tag list " + ex.Message;
				}
				this.Cursor = Cursors.Default;
			}
		}

		private void rdoXML_CheckedChanged(object sender, System.EventArgs e)
		{
			mReader.TagListFormat = "XML";	
		}

		private void rdoText_CheckedChanged(object sender, System.EventArgs e)
		{
			mReader.TagListFormat = "Text";
		}

		private void textReaderTalk_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			String command = "";
			try
			{
				if (e.KeyCode == Keys.Enter)
				{
					command = textReaderTalk.Lines[textReaderTalk.Lines.GetUpperBound(0)-1];
					if (command.Length > 0)
					{
						DisplayText(mReader.SendReceive(command,false));
					}
				}
			}
			catch(Exception ex)
			{
				lblStatus.Text = "Exception in textReaderTalk_KeyUp(): " + ex.Message;
			}
		}

		private void cboPorts_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			mReader.SerialPort = cboPorts.Text;
		}

		private void cboHostBaudRate_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try 
			{
				if (cboHostBaudRate.Enabled)
					mReader.HostBaudRate = int.Parse(cboHostBaudRate.Text);
			}
			catch (Exception ex)
			{
				lblStatus.Text = ex.Message;
			}
		}

        private void btnStats_Click(object sender, EventArgs e)
        {
            try
            {
                mlMyStatistics = mReader.GetStatistics();
                grvStats.DataSource = mlMyStatistics;
                grvStats.Refresh();
            }
            catch (Exception ex)
            {
                lblStatus.Text = ex.Message;
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
			if (mReader != null)
			{
                if (mReader.IsConnected)
                {
                    try { mReader.AutoMode = "OFF"; }
                    catch { }
                }
				mReader.Dispose();
			}
        }

    }
}
